; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; The information contained herein is confidential, proprietary
; to Autodesk, Inc., and considered a trade secret as defined
; in section 499C of the penal code of the State of California.
; Use of this information by anyone other than authorized
; employees of Autodesk, Inc. is granted only under a written
; non-disclosure agreement, expressly prescribing the scope and
; manner of such use.
;
; 22-Dec-04 NEHolt - prelim implementation of SORTMODE attrib (nth 59 GBL_wd_m) on WD_M.dwg block
; 15-Dec-04 NEHolt (616702) - problem losing GBL_wd_m and GBL_wd_pnlm in MDI mode when switch to the
;    actual wd_m.dwg or wd_pnlm.dwg dwg. Fixed. Also removed local copies of some routines that are already
;    defined in wdcom1.lsp.
; 21-Sep-04 PanQ, Replace run script command to support MDI and add function for share varibles between drawings
; 04-Aug-04 PanQ reomove the setting of force to set to SDI.
; 22-Jun-04 NEHolt (574405) - "RENAME" command was not globalized
; 08-Jun-04 LeeH; (562004) - Ensure that the WD_M or WD_PNLM block exist before 
;        allowing to copy their settings.
; 10-May-04 LeeH; globalized replace of 'strcase' with 'ace_strcase'
; 16-Apr-04 LeeH; (562810) Changed call to non existent "wdcom9.dcl" to "wdvis.dcl"
; 02-June-03 Mauro Sist; globalized with "(c:wd_msg ...)" calls for messages/prompts
; 26-Feb-03 NEHolt; removed legacy name reference
; 03-Dec-02 NEHolt; additional cleanup
; 08-Feb-01 NEHolt; clean-up for conversion to VIA
; 20-May-99 NEHolt; use AFLAGS to preset ATTDEFS to "invisible" mode;
;    added more error checking to the "layer rename" routine
; 21-Feb-99 PMMurnen; Created. Copyright (c)1999 N8 Solutions, Inc.
; -------------  C O P Y 2 W D M . L S P
; PURPOSE: Copy drawing's settings back to the WD_M or WD_PNLM drawing

;**21-Sep-04 PanQ. Function of set variable need to be shared between next opened drawing
(defun wd_copy2wdm_save_global_variables ( / ) ; ** 15-Dec-04 NEHolt renamed
;  (ace_set_temp_variables
;    "GBL_wd_m"
;    "GBL_wd_pnlm"
;  )
; ** 15-Dec-04 NEHolt some problem with above, use VisualLisp blackboard instead
  (vl-bb-set '_GBL_WD_M GBL_wd_m)
  (vl-bb-set '_GBL_WD_PNLM GBL_wd_pnlm)
)
;**


; ----
(defun wd_copy2wdm_which_wdm ( / str dcl_id cancel wdm_dwg wdm_state wdpnlm_state) ; ** 08-Jun-04 LeeH; wdm_state wdpnlm_state
  (setq str nil)
; ** 08-Jun-04.sn LeeH  
  (setq wdm_state 0 wdpnlm_state 0)
  (if (not (ssget "_X" '((-4 . "<AND") (0 . "INSERT") (2 . "WD_M") (-4 . "AND>"))))
    (setq wdm_state 1)
  )
  (if (not (ssget "_X" '((-4 . "<AND") (0 . "INSERT") (2 . "WD_PNLM") (-4 . "AND>"))))
    (setq wdpnlm_state 1)
  )
  (if (or (= wdm_state 0)(= wdpnlm_state 0))
    (progn
; ** 08-Jun-04.en    
      (setq dcl_id (load_dialog (strcat GBL_wd_sup "COPY2WDM.dcl")))
      ; ** 03-Dec-02 NEHolt  
      (if (not (new_dialog "which_wdm" dcl_id))
         (alert (strcat GBL_wd_sup "copy2wdm.dcl" " " (c:wd_msg "GEN003" nil "not found")))
      ; ELSE
      ; **
         (progn
            (setq cancel nil)
; ** 08-Jun-04.sn LeeH
;;            (setq wdm_dwg "wdm") ; default to WD_M
            (if (= wdm_state 0)
               (setq wdm_dwg "wdm") ; default to WD_M
            ; else
               (setq wdm_dwg "wdpnlm") 
            )
; ** 08-Jun-04.en            
            (set_tile "wdm_dwg" wdm_dwg)
            (mode_tile "wdm" wdm_state)
            (mode_tile "wdpnlm" wdpnlm_state)
            (action_tile "wdm_dwg" "(setq wdm_dwg $value)")
            (action_tile "cancel" "(setq cancel 1)")
            (action_tile "help" "(wd_doc_helptoc \"wddoc\" \"help_which_wdm\")") ; ** 03-Dec-02 NEHolt
            (start_dialog)
            (unload_dialog dcl_id)
            (if (not cancel)
            (if (= wdm_dwg "wdm")
               (setq str "WD_M")
               (setq str "WD_PNLM")
            )
            )
      ) )
; ** 08-Jun-04.sn LeeH
    )
  ; else - no block found in drawing
    (alert (c:wd_msg "CP2WDM014" nil "WD_M and WD_PNLM block insert not found on this drawing"))
  )
; ** 08-Jun-04.en
  str
)
; ------
(defun c:wd_copy2wdm ( / x dnam nam wdmnam lst rtrn)
  (if Aw_debug (princ "\nIN:wd_copy2wdm"))
  (princ (strcat "\n" (c:wd_msg "CP2WDM001" nil "Copy to WD_M") "\n"))
  (setq err_old *error*) ; Save old error handler
  (setq *error* wd_1_cserr) ; New error handler
  (setq #cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  ; This plus an UNDO END at end of program provides complete UNDO
  (command "_.UNDO" "_MARK")
  (command "_.UNDO" "_GROUP")

  ; see what drawing is open
  (setq nam (ace_strcase (getvar "DWGNAME")))
  ; is it one of the WD settings drawings?
  (if (OR (= nam "WD_M.DWG") (= nam "WD_PNLM.DWG"))
    (progn
      (setq wdmnam (wd_1_current_full_name))
      ; need to get the drawing to open and read settings from to transfer back
      (setq x GBL_wd_prj)
      (if (OR (= x nil) (= x ""))
        (progn
          (setq x (wd_4_all_slashes_forward (getenv "WD_PROJ")))
          (if (AND (/= x nil) (> (strlen x) 0))
            (progn
              (if (/= (substr x (strlen x) 1) "/")
                (setq x (strcat x "/"))
      ) ) ) ) )

      ; Default to directory where cur project is or env "WD_PROJ"
      (if (not (setq x (car (wd_4_split_fname x)))) (setq x ""))
; ** 16-Apr-04; LeeH - globalization      
      (setq dnam (getfiled
         (c:wd_msg "CP2WDM013" nil "Select drawing with desired WD settings") x "DWG" 0))
;;;         "Select drawing with desired WD settings" x "DWG" 0))
; **
      (if dnam
        (progn
          ; create a script file to open dnam, get its settings
          ; save them out, open wdmnam and update its attdefs
          (setq lst (list (strcat "(load \"" (strcat GBL_wd_sup "copy2wdm")"\")")
                      (strcat "(c:wd_copy2wdm_dodnam \""
                        (wd_4_all_slashes_forward wdmnam) "\")")))
          (setq rtrn (wd_copy2wdm_build_script 1
                  "CPY2WDM1.SCR" (list dnam)
                  lst nil nil))
          (if (= rtrn 1) ; success, run it
            (progn
              (wd_copy2wdm_save_global_variables);21-Sep-04 PanQ, Set variables need to be saved in current drawing
              (command (wd_scr_get_script_cmd) (strcat GBL_wd_usr "CPY2WDM1.SCR"));21-Sep-04 PanQ, Change to Support MDI
          ) )
      ) )
    )
  ; else
    (progn
      (setq dnam nam)
      ; see which drawing user wants to transfer back to
      (setq wdmnam (wd_copy2wdm_which_wdm))
      (if wdmnam (c:wd_copy2wdm_dodnam wdmnam))
  ) )

  (command "_.UNDO" "_E")
  (if #cmdecho (setvar "CMDECHO" #cmdecho))
  (setq *error* err_old)     ; Restore standard *error* handler
  (princ)
)
; ----
(defun c:wd_copy2wdm_dodnam ( wdmnam / rtrn lst)
  ; at this point the active drawing is the one with the settings wanted
  ; read active drawing's current settings
  (setq err_old *error*) ; Save old error handler
  (setq *error* wd_1_cserr) ; New error handler
  (setq #cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (if (= (cadr (wd_4_split_fname wdmnam)) "WD_M")
    (progn
      ; make sure WD_M exists first so won't get inserted now
      (if (not (ssget "_X" '((-4 . "<AND") (0 . "INSERT") (2 . "WD_M")
               (-4 . "AND>"))))
        (progn
          (alert (c:wd_msg "CP2WDM012" nil "WD_M block insert not found on this drawing"))
          (exit)
      ) )
      (setq GBL_wd_m nil)
      (c:wd_read_dwg_params)
      ; get the WD layers and assigned colors
      (setq GBL_wd_laycol_lst (wd_copy2wdm_get_laycol
        (list 26 27 28 29 32 33 34 35 36 37 38 39 40 44 45 48 54) GBL_wd_m))
    )
  ; else panel
    (progn
      ; make sure WD_PNLM exists first so won't get inserted now
; ** 08-Jun-04.mod LeeH      
;;      (if (not (ssget "_X" '((-4 . "<AND") (0 . "INSERT") (2 . "WD_M")
      (if (not (ssget "_X" '((-4 . "<AND") (0 . "INSERT") (2 . "WD_PNLM")
               (-4 . "AND>"))))
        (progn
          (alert (c:wd_msg "CP2WDM012" nil "AutoCAD Electrical WD_PNLM block is not present on drawing."))
          (exit)
      ) )
      (setq GBL_wd_pnlm nil)
      (c:wd_read_pnldwg_params)
      ; get the WD layers and assigned colors
      (setq GBL_wd_laycol_lst (wd_copy2wdm_get_laycol
        (list 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 36) GBL_wd_pnlm))
  ) )

  ; 04-Aug-04 PanQ Change for MDI Supporting
  (if (= (getvar "SDI") 1)
    (progn
      (setq #lispinit (getvar "LISPINIT"))
      (setvar "LISPINIT" 0) ; preserve values
    )
  )
  ;**
  
  ; find the wdmnam drawing itself so can open it
  (setq wdmnam (wd_copy2wdm_block_exist_disk wdmnam))
  (if wdmnam
    (progn
      ; write the script out to open the wdmnam and update it's attdefs
      (setq lst (list (strcat "(load \"" (strcat GBL_wd_sup "copy2wdm")"\")")
                      "(c:wd_copy2wdm_dowdm)"))
      (setq rtrn (wd_copy2wdm_build_script 1
              "CPY2WDM2.SCR" (list wdmnam)
              lst nil nil))
      (if (= rtrn 1) ; success, run it
        (progn
          (wd_copy2wdm_save_global_variables);21-Sep-04 PanQ, Set variables need to be saved in current drawing
          (command (wd_scr_get_script_cmd) (strcat GBL_wd_usr "CPY2WDM2.SCR"));21-Sep-04 PanQ, change script command to new one
      ) )
  ) )
  (if #cmdecho (setvar "CMDECHO" #cmdecho))
  (setq *error* err_old)     ; Restore standard *error* handler
  (princ)
)
; ----
(defun c:wd_copy2wdm_dowdm ( / nam lay_lst col_lst ix laynam colnam _lst)
  (setq err_old *error*) ; Save old error handler
  (setq *error* wd_1_cserr) ; New error handler
  (setq #cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  ; This plus an UNDO END at end of program provides complete UNDO
  (command "_.UNDO" "_MARK")
  (command "_.UNDO" "_GROUP")
  ; see what drawing is open
  (setq nam (ace_strcase (getvar "DWGNAME")))
  (cond
    ((= nam "WD_M.DWG")
      (wd_copy2wdm_wdm_params)
    )
    ((= nam "WD_PNLM.DWG")
      (wd_copy2wdm_wdpnlm_params)
    )
  )
  ; create any layers needed and make sure colors are assigned correctly
  ; info held in GBL_wd_laycol_lst
  (setq ix 0)
  (setq lay_lst (car GBL_wd_laycol_lst))
  (setq col_lst (cadr GBL_wd_laycol_lst))
  (while (< ix (length lay_lst))
    (setq laynam (nth ix lay_lst))
    (setq colnam (nth ix col_lst))
    ; make sure layer exists
    (if (setq _lst (tblsearch "LAYER" laynam))
      (progn
        ; exists, make sure color is right
        (if (AND colnam (/= colnam (cdr (assoc 62 _lst))))
          (progn
            (command "_.LAYER" "_C" colnam laynam "")
            (princ (strcat "\n" (c:wd_msg "CP2WDM004" (list laynam (itoa colnam)) "Layer %1 changed to color %2")))
        ) )
      )
    ; else need to create the layer
      (progn
        (command "_.LAYER" "_N" laynam "")
        (if (not colnam)
          (princ (strcat "\n" (c:wd_msg "CP2WDM005" (list laynam) "Layer %1 created")))
        ; ELSE  
          (progn
            (command "_.LAYER" "_C" colnam laynam "")
            (princ (c:wd_msg "CP2WDM006" (list laynam (itoa colnam)) "Layer %1 created, color %2"))
        ) )
    ) )
    (setq ix (1+ ix))
  )
  (setq GBL_wd_m nil)
  (setq GBL_wd_pnlm nil)
  (command "_.UNDO" "_E")

  ; 04-Aug-04 PanQ Change for MDI Supporting
  (if (AND #lispinit (= (getvar "SDI") 1)) (setvar "LISPINIT" #lispinit))
  ;**
  
  (if #cmdecho (setvar "CMDECHO" #cmdecho))
  (setq *error* err_old)     ; Restore standard *error* handler
  (princ)
)
; -----
(defun wd_copy2wdm_wdm_params ( / ss edd enn atnam en ix
  wireref_lay misc_data)
  ; write current GBL_wd_m values back to appropriate attdefs
  (if Aw_debug (princ "\nIN:wd_copy2wdm_wdm_params"))
  (setq wireref_lay nil misc_data nil)
  (setq en nil)
  (setq ss (ssget "_X" '((0 . "ATTDEF"))))
  (if (/= ss nil)
    (progn
      (setq ix 0)
; ** 15-Dec-04 NEHolt      
      ; Retrieve saved GBL_wd_m list from "black board" inter-doc storage
      (setq GBL_wd_m (vl-bb-ref "_GBL_WD_M"))
; **      
      (while (< ix (sslength ss))
        (setq enn (ssname ss ix))
        (setq edd (entget enn))
        (setq atnam (cdr (assoc 2 edd)))
        (cond
          ((= atnam "RUNGHORV") (wd_copy2wdm_cha_at (nth 0 GBL_wd_m) edd))
          ((= atnam "REFNUMS") (wd_copy2wdm_cha_at (nth 1 GBL_wd_m) edd))
          ((= atnam "TAGMODE") (wd_copy2wdm_cha_at (nth 2 GBL_wd_m) edd))
          ((= atnam "TAG-START") (wd_copy2wdm_cha_at (nth 3 GBL_wd_m) edd))
          ((= atnam "TAG-RSUF") (wd_copy2wdm_cha_at (nth 4 GBL_wd_m) edd))
          ((= atnam "TAGFMT") (wd_copy2wdm_cha_at (nth 5 GBL_wd_m) edd))
          ((= atnam "WIREMODE") (wd_copy2wdm_cha_at (nth 6 GBL_wd_m) edd))
          ((= atnam "WIRE-START") (wd_copy2wdm_cha_at (nth 7 GBL_wd_m) edd))
          ((= atnam "WIRE-RSUF") (wd_copy2wdm_cha_at (nth 8 GBL_wd_m) edd))
          ((= atnam "WIREFMT") (wd_copy2wdm_cha_at (nth 9 GBL_wd_m) edd))
          ((= atnam "WINC") (wd_copy2wdm_cha_at (nth 10 GBL_wd_m) edd))
          ((= atnam "RUNGDIST") (wd_copy2wdm_cha_at (nth 11 GBL_wd_m) edd))
          ((= atnam "DLADW") (wd_copy2wdm_cha_at (nth 12 GBL_wd_m) edd))
          ; don't update this one back
          ;((= atnam "SHEET") (wd_copy2wdm_cha_at (nth 13 GBL_wd_m) edd))
          ((= atnam "XREFFMT") (wd_copy2wdm_cha_at (nth 14 GBL_wd_m) edd))
          ((= atnam "RUNGINC") (wd_copy2wdm_cha_at (nth 15 GBL_wd_m) edd))
         ;     ((= atnam "DRWRUNG") (setq d_r (cdr (assoc 1 edd))))
          ((= atnam "PH3SPACE") (wd_copy2wdm_cha_at (nth 17 GBL_wd_m) edd))
          ((= atnam "DATUMX") (wd_copy2wdm_cha_at (nth 18 GBL_wd_m) edd))
          ((= atnam "DATUMY") (wd_copy2wdm_cha_at (nth 19 GBL_wd_m) edd))
          ((= atnam "DISTH") (wd_copy2wdm_cha_at (nth 20 GBL_wd_m) edd))
          ((= atnam "DISTV") (wd_copy2wdm_cha_at (nth 21 GBL_wd_m) edd))
          ((= atnam "CHAR_H") (wd_copy2wdm_cha_at
                    (wd_1_lst_to_delim_str (nth 22 GBL_wd_m) ",") edd))
          ((= atnam "CHAR_V") (wd_copy2wdm_cha_at
                    (wd_1_lst_to_delim_str (nth 23 GBL_wd_m) ",") edd))
          ((= atnam "HORIZ_FIRST") (wd_copy2wdm_cha_at (nth 24 GBL_wd_m) edd))
          ((= atnam "XY_DELIM") (wd_copy2wdm_cha_at (nth 25 GBL_wd_m) edd))
          ((= atnam "WIRELAYS") (wd_copy2wdm_cha_at
                    (wd_1_lst_to_delim_str (nth 26 GBL_wd_m) ",") edd))
          ((= atnam "WIRENO_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 27 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 27 GBL_wd_m) edd))
          ((= atnam "WIRECOPY_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 28 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 28 GBL_wd_m) edd))
          ((= atnam "WIREFIXED_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 29 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 29 GBL_wd_m) edd))
          ((= atnam "UNIT_SCL") (wd_copy2wdm_cha_at (nth 30 GBL_wd_m) edd))
          ((= atnam "FEATURE_SCL") (wd_copy2wdm_cha_at (nth 31 GBL_wd_m) edd))
          ((= atnam "TAG_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 32 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 32 GBL_wd_m) edd))
          ((= atnam "XREF_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 33 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 33 GBL_wd_m) edd))
          ((= atnam "DESC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 34 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 34 GBL_wd_m) edd))
          ((= atnam "TERM_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 35 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 35 GBL_wd_m) edd))
          ((= atnam "CXREF_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 36 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 36 GBL_wd_m) edd))
          ((= atnam "CDESC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 37 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 37 GBL_wd_m) edd))
          ((= atnam "LOC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 38 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 38 GBL_wd_m) edd))
          ((= atnam "POS_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 39 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 39 GBL_wd_m) edd))
          ((= atnam "MISC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 40 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 40 GBL_wd_m) edd))
          ((= atnam "WLEADERS") (wd_copy2wdm_cha_at (nth 41 GBL_wd_m) edd))
          ((= atnam "PLC_STYLE") (wd_copy2wdm_cha_at (nth 42 GBL_wd_m) edd))
          ((= atnam "ARROW_STYLE") (wd_copy2wdm_cha_at (nth 43 GBL_wd_m) edd))
          ((= atnam "LINK_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 44 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 44 GBL_wd_m) edd))
          ((= atnam "COMP_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 45 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 45 GBL_wd_m) edd))
          ; don't update this one back
          ;((= atnam "SHEETDWGNAME") (wd_copy2wdm_cha_at (nth 46 GBL_wd_m) edd))
          ((= atnam "ALT_XREFFMT") (wd_copy2wdm_cha_at (nth 47 GBL_wd_m) edd))
          ((= atnam "TAGFIXED_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 48 GBL_wd_m))
            (wd_copy2wdm_cha_at (nth 48 GBL_wd_m) edd))
          ((= atnam "GAP_STYLE") (wd_copy2wdm_cha_at (nth 49 GBL_wd_m) edd))
          ((= atnam "MISC_FLAGS") (wd_copy2wdm_cha_at (nth 50 GBL_wd_m) edd))
          ((= atnam "IEC_PROJ") (wd_copy2wdm_cha_at (nth 51 GBL_wd_m) edd))
          ((= atnam "IEC_INST") (wd_copy2wdm_cha_at (nth 52 GBL_wd_m) edd))
          ((= atnam "IEC_LOC") (wd_copy2wdm_cha_at (nth 53 GBL_wd_m) edd))
          ((= atnam "WIREREF_LAY")
            (setq wireref_lay T)
            (if (nth 54 GBL_wd_m)
              (progn
                (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 54 GBL_wd_m))
                (wd_copy2wdm_cha_at (nth 54 GBL_wd_m) edd)
            ) )
          )
          ((= atnam "MISC_DATA")
            (setq misc_data T)
            (if (nth 55 GBL_wd_m)
              (wd_copy2wdm_cha_at (nth 55 GBL_wd_m) edd)
            )
          )
          ((= atnam "FAN_INOUT_LAYS")
            (if (AND (nth 56 GBL_wd_m) (/= (nth 56 GBL_wd_m) ""))             
              (wd_copy2wdm_cha_at (wd_1_lst_to_delim_str (nth 56 GBL_wd_m) ",") edd)  
          ) )    
          ((= atnam "FAN_INOUT_STYLE") 
            (if (AND (nth 57 GBL_wd_m)(/= (nth 57 GBL_wd_m) ""))
              (wd_copy2wdm_cha_at (nth 57 GBL_wd_m) edd)                
          ) )    
          ((= atnam "LOCBOX_LAY") 
            (if (AND (nth 58 GBL_wd_m)(/= (nth 58 GBL_wd_m) ""))
              (wd_copy2wdm_cha_at (nth 58 GBL_wd_m) edd)                
          ) )               
; ** 22-Dec-04 NEHolt
          ((= atnam "SORTMODE") (wd_copy2wdm_cha_at (nth 59 GBL_wd_m) edd))
; 13-Aug-07 Mei
	  ((= atnam "XREF_STYLE") (wd_copy2wdm_cha_at (nth 60 GBL_wd_m) edd))
	  ((= atnam "XREF_FLAGS") (wd_copy2wdm_cha_at (nth 61 GBL_wd_m) edd))
	  ((= atnam "XREF_UNUSEDSTYLE") (wd_copy2wdm_cha_at (nth 62 GBL_wd_m) edd))
 	  ((= atnam "XREF_FILLWITH") (wd_copy2wdm_cha_at (nth 63 GBL_wd_m) edd))
  	  ((= atnam "XREF_SORT") (wd_copy2wdm_cha_at (nth 64 GBL_wd_m) edd))
  	  ((= atnam "XREF_TXTBTWN") (wd_copy2wdm_cha_at (nth 65 GBL_wd_m) edd))
  	  ((= atnam "XREF_GRAPHIC") (wd_copy2wdm_cha_at (nth 66 GBL_wd_m) edd))
  	  ((= atnam "XREF_GRAPHICSTYLE") (wd_copy2wdm_cha_at (nth 67 GBL_wd_m) edd))
  	  ((= atnam "XREF_CONTACTMAP") (wd_copy2wdm_cha_at (nth 68 GBL_wd_m) edd))
  	  ((= atnam "XREF_TBLSTYLE") (wd_copy2wdm_cha_at (nth 69 GBL_wd_m) edd))
  	  ((= atnam "XREF_TBLTITLE") (wd_copy2wdm_cha_at (nth 70 GBL_wd_m) edd))
  	  ((= atnam "XREF_TBLINDEX") (wd_copy2wdm_cha_at (nth 71 GBL_wd_m) edd))
  	  ((= atnam "XREF_TBLFLDNAMS") (wd_copy2wdm_cha_at (nth 72 GBL_wd_m) edd))
   	  ((= atnam "XREF_TBLCOLJUST") (wd_copy2wdm_cha_at (nth 73 GBL_wd_m) edd))
  	  ((= atnam "WNUM_OFFSET") (wd_copy2wdm_cha_at (nth 74 GBL_wd_m) edd))
  	  ((= atnam "WNUM_FLAGS") (wd_copy2wdm_cha_at (nth 75 GBL_wd_m) edd))
  	  ((= atnam "WNUM_GAP") (wd_copy2wdm_cha_at (nth 76 GBL_wd_m) edd))
; **	  
        ) ; end cond
        (setq ix (1+ ix))
      ) ;end while
      (if (not wireref_lay) ; need to insert it
        (wd_copy2wdm_ins_attdef "WIREREF_LAY"
          "Term/Sig arrow wire number layer" "WIREREF" "0,-0.61" 0.01)
      )
      (if (not misc_data) ; need to insert it
        (wd_copy2wdm_ins_attdef "MISC_DATA" "" "" "0,-0.63" 0.01)
      )
  ) )
  (if Aw_debug (princ "\nOUT:wd_copy2wdm_wdm_params"))
)
; ----
(defun wd_copy2wdm_cha_at ( atval edd / newed x)
  (if (/= atval (cdr (assoc 1 edd)))
    (progn
      (setq newed (subst (cons 1 atval) (assoc 1 edd) edd))
      (if newed
        (progn
          (entmod newed)
          (if (= (cdr (assoc 1 edd)) "")
            (setq x (c:wd_msg "PDWGS002" nil "(blank)"))
          ; ELSE  
            (setq x (cdr (assoc 1 edd)))
          )
          (princ (strcat "\n" (c:wd_msg "GEN080" (list (cdr (assoc 2 edd)) x atval) "%1: %2 --> %3")))
      ) )
  ) )
)
; -----
(defun wd_copy2wdm_wdpnlm_params ( / ss edd enn atnam en ix )
  (if Aw_debug (princ "\nIN:wd_copy2wdm_wdpnlm_params"))
  (setq en nil)
  (setq ss (ssget "_X" '((0 . "ATTDEF"))))
  (if (/= ss nil)
    (progn
      (setq ix 0)
; ** 15-Dec-04 NEHolt      
      ; Retrieve saved GBL_wd_pnlm list from "black board" inter-doc storage
      (setq GBL_wd_pnlm (vl-bb-ref "_GBL_WD_PNLM"))
; **      
      (while (< ix (sslength ss))
        (setq enn (ssname ss ix))
        (setq edd (entget enn))
        (setq atnam (cdr (assoc 2 edd)))
        (cond
          ((= atnam "ITEM_NUM") (wd_copy2wdm_cha_at (nth 0 GBL_wd_pnlm) edd))
          ((= atnam "ITEM_FMT") (wd_copy2wdm_cha_at (nth 1 GBL_wd_pnlm) edd))
          ((= atnam "BALL_TSZ") (wd_copy2wdm_cha_at (nth 2 GBL_wd_pnlm) edd))
          ((= atnam "BALL_TGAP") (wd_copy2wdm_cha_at (nth 3 GBL_wd_pnlm) edd))
          ((= atnam "BALL_ATYP") (wd_copy2wdm_cha_at (nth 4 GBL_wd_pnlm) edd))
          ((= atnam "BALL_ASZ") (wd_copy2wdm_cha_at (nth 5 GBL_wd_pnlm) edd))
          ((= atnam "BALL_TYPE") (wd_copy2wdm_cha_at (nth 6 GBL_wd_pnlm) edd))
          ((= atnam "BALL_CDIA") (wd_copy2wdm_cha_at (nth 7 GBL_wd_pnlm) edd))
          ((= atnam "BALL_CFIT") (wd_copy2wdm_cha_at (nth 8 GBL_wd_pnlm) edd))
          ((= atnam "BALL_CGAP") (wd_copy2wdm_cha_at (nth 9 GBL_wd_pnlm) edd))
          ((= atnam "BALL_EHZ") (wd_copy2wdm_cha_at (nth 10 GBL_wd_pnlm) edd))
          ((= atnam "BALL_EVT") (wd_copy2wdm_cha_at (nth 11 GBL_wd_pnlm) edd))
          ((= atnam "BALL_EFIT") (wd_copy2wdm_cha_at (nth 12 GBL_wd_pnlm) edd))
          ((= atnam "BALL_EGAP") (wd_copy2wdm_cha_at (nth 13 GBL_wd_pnlm) edd))
          ((= atnam "BALL_PSHP") (wd_copy2wdm_cha_at (nth 14 GBL_wd_pnlm) edd))
          ((= atnam "BALL_PDIA") (wd_copy2wdm_cha_at (nth 15 GBL_wd_pnlm) edd))
          ((= atnam "BALL_PFIT") (wd_copy2wdm_cha_at (nth 16 GBL_wd_pnlm) edd))
          ((= atnam "BALL_PGAP") (wd_copy2wdm_cha_at (nth 17 GBL_wd_pnlm) edd))
          ((= atnam "PTAG_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 18 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 18 GBL_wd_pnlm) edd))
          ((= atnam "PITEM_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 19 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 19 GBL_wd_pnlm) edd))
          ((= atnam "PDESC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 20 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 20 GBL_wd_pnlm) edd))
          ((= atnam "PMFG_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 21 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 21 GBL_wd_pnlm) edd))
          ((= atnam "PCAT_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 22 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 22 GBL_wd_pnlm) edd))
          ((= atnam "PLOC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 23 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 23 GBL_wd_pnlm) edd))
          ((= atnam "PMNT_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 24 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 24 GBL_wd_pnlm) edd))
          ((= atnam "PGRP_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 25 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 25 GBL_wd_pnlm) edd))
          ((= atnam "PTERM_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 26 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 26 GBL_wd_pnlm) edd))
          ((= atnam "PWIRE_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 27 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 27 GBL_wd_pnlm) edd))
          ((= atnam "PRTG_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 28 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 28 GBL_wd_pnlm) edd))
          ((= atnam "PMISC_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 29 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 29 GBL_wd_pnlm) edd))
          ((= atnam "PBAL_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 30 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 30 GBL_wd_pnlm) edd))
          ((= atnam "PCOMP_LAYS") (wd_copy2wdm_cha_at
            (wd_1_lst_to_delim_str  (nth 31 GBL_wd_pnlm) ",")  edd))
          ((= atnam "PNPG_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 32 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 32 GBL_wd_pnlm) edd))
          ((= atnam "PNPT_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 33 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 33 GBL_wd_pnlm) edd))
          ((= atnam "PNPD_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 34 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 34 GBL_wd_pnlm) edd))
          ((= atnam "PLAY_FLG") (wd_copy2wdm_cha_at (nth 35 GBL_wd_pnlm) edd))
          ((= atnam "PASSY_LAY")
            (wd_copy2wdm_rename_lay (cdr (assoc 1 edd)) (nth 36 GBL_wd_pnlm))
            (wd_copy2wdm_cha_at (nth 36 GBL_wd_pnlm) edd))
          ((= atnam "PX_SPC") (wd_copy2wdm_cha_at (nth 37 GBL_wd_pnlm) edd))
          ((= atnam "PY_SPC") (wd_copy2wdm_cha_at (nth 38 GBL_wd_pnlm) edd))
        ) ; end cond
        (setq ix (1+ ix))
      ) ; end while
  ) )
  (if Aw_debug (princ "\nOUT:wd_copy2wdm_wdpnlm_params"))
)
; ----
(defun wd_copy2wdm_get_laycol ( nth_lst gbl_lst / lay_lst col_lst w lay
                flag add_lst l _lst x)
  (if Aw_debug (princ "\nIN:wd_copy2wdm_get_laycol"))
  (setq lay_lst '())
  ; list of "nth" indicies into GBL_wd_m or GBL_wd_pnlm for LAYER names
  (foreach w nth_lst
    (setq lay (nth w gbl_lst))
    (if (listp lay)
      (setq lay_lst (append lay_lst lay))
      (setq lay_lst (append lay_lst (list lay)))
    )
  )
  ; now see if any existing layers match and should be added
  (setq flag T) ; flag to rewind to beginning of LAYER table
  (setq add_lst '())
  (while (/= (setq x (tblnext "LAYER" flag)) nil)
    (setq flag nil)
    (setq lay (cdr (assoc 2 x)))
    (if (not (member lay lay_lst))
      (progn
        ; see if it matches any of the wildcards
        (foreach l lay_lst
          (if (wcmatch lay l)
            (setq add_lst (append add_lst (list lay)))
          )
        )
      )
    )
  )
  (if add_lst (setq lay_lst (append lay_lst add_lst)))
  (setq lay_lst (acad_strlsort lay_lst))
  ; go thru and take out the ones with wildcards
  (setq _lst '())
  (foreach lay lay_lst
    (if (AND (= (wd_1_strchr lay "*") 0) (= (wd_1_strchr lay "?") 0))
      (setq _lst (cons lay _lst))
    )
  )
  (setq lay_lst (reverse _lst))
  ; now need to get the colors assigned to each one
  (setq col_lst '())
  (foreach lay lay_lst
    (if (setq _lst (tblsearch "LAYER" lay))
      (setq col_lst (cons (cdr (assoc 62 _lst)) col_lst))
      (setq col_lst (cons nil col_lst))
    )
  )
  (setq col_lst (reverse col_lst))
  (if Aw_debug (princ "\nOUT:wd_copy2wdm_get_laycol"))
  (list lay_lst col_lst) ; return lists
)
; -----
(defun wd_copy2wdm_block_exist_disk ( nam / rtrn x xx ix split)

  (setq split (wd_4_split_fname nam))
  (setq rtrn nil)
;  (if (> (wd_1_strchr (cadr split) " ") 0)
;     (alert (c:wd_msg "CP2WDM013" (list (cadr split)) "Block name \"%1\" cannot have an embedded blank space")))
  (if (/= (car split) "") ; original had full path. Try it.
    (progn
      (setq rtrn (findfile (strcat (car split) (cadr split) ".dwg")))
  ) )
  (if (= rtrn nil)
    (progn
      (if (AND GBL_wd_usr (/= GBL_wd_usr ""))
        (setq rtrn (findfile (strcat GBL_wd_usr (cadr split) ".dwg")))
  ) ) )
  (if (= rtrn nil)
    (progn ; Try "GBL_wd_prj" path
      (if (AND GBL_wd_prj (/= GBL_wd_prj ""))
        (progn
          (setq xx (wd_4_split_fname GBL_wd_prj))
          (setq rtrn (findfile (strcat (car xx) (cadr split) ".dwg")))
  ) ) ) )
  (if (= rtrn nil)
    (if (AND GBL_wd_lib (/= GBL_wd_lib ""))
      (progn
        (setq x (c:wd_delim_str_to_lst GBL_wd_lib ";"))
        (setq ix 0)
        (while (AND (not rtrn) (< ix (length x)))
          (setq xx (nth ix x)) ; get next (or only path)
          (if (AND (/= xx "") (/= (substr xx (strlen xx)) "/")
               (/= (substr xx (strlen xx)) "\\") )
            (setq xx (strcat xx "/")))
          (setq rtrn (findfile (strcat xx (cadr split) ".dwg")))
          (setq ix (1+ ix))
  ) ) ) )
  (if (= rtrn nil)
    (if (AND GBL_wd_sup (/= GBL_wd_sup ""))
      (setq rtrn (findfile (strcat GBL_wd_sup (cadr split) ".dwg")))))
  (if (= rtrn nil)
    (setq rtrn (findfile (strcat (cadr split) ".dwg")))
  )
  rtrn
)
; ----
(defun wd_copy2wdm_build_script ( nosave fnam dwglst cmdfirstlst
           cmdremainderlst cmdpostlst / f x dcnt ix slen rtrn str savcur)

  ; G E N E R I C    B A T C H   S C R I P T   G E N E R A T O R
  ; "dwglst" = drawing list, build script from this drawing list
  ; "nosave" = 1 for no save/qsave, nil always save,
  ;          = 2 save only if database change
  (if Aw_debug (princ "\nIN:wd_copy2wdm_build_script")) ; 14-Jun-98 NEHolt
  (setq rtrn nil)
  (setq savcur (wd_1_current_full_name)) ; save current drawing name

  (if (/= dwglst nil)
    (progn
      (setq dcnt (length dwglst))
      ; Create script file in "GBL_wd_usr" subdirectory
      (setq f (open (strcat GBL_wd_usr fnam) "w"))
      (if (= f nil)
        (alert (strcat (c:wd_msg "SCR002" nil "Could not create script file") " " fnam))
      ; ELSE
        (progn ; Success so far, continue
          ; Output first drawing to script file
          ; Check if current dwg is first dwg in list to do.
          (if (/= (ace_strcase savcur)
             (ace_strcase (wd_4_all_slashes_backward (car dwglst))))
            (progn ; current dwg doesn't seem to be the 1st in proj
              (if (not (wd_copy2wdm_do_qsave))
                (progn ; user quit
                  (close f)
                  (setq f nil)
                  (exit)
              ) )
              (if (wd_scr_is_sdi)
                (progn
              	  (write-line "(if (/= (getvar \"DBMOD\") 0)(command \"_.OPEN\" \"_Y\")(command \"_.OPEN\"))" f)
                  (write-line (wd_1_longfname_delims (car dwglst)) f)
                )
              ; else
                (write-line (strcat "#ACE_PDSX_OPEN_SDI _Y " (wd_1_longfname_delims (car dwglst))) f)
              )
            )
            ; ELSE
            (princ (strcat "\n" (c:wd_msg "SCR003" nil "(Current drawing is first in list)")))
          )
          (write-line "_.zoom _e" f) ; in case zoomed way down
          (if (<= (wd_copy2wdm_acadver) 13) ; ** 26-Sep-98
            (if (OR (not nosave) (= nosave 2)) (write-line ; *** 26-Aug-98 PMM
              "(if (= (logand (getvar \"UNDOCTL\") 1) 1)(command \"_.UNDO\" \"_C\" \"_N\"))" f))
          )
          (setq str (strcat "(princ \"  >> Drawing 1 of " (itoa dcnt) "\")(princ)"))
          (write-line str f)
          (foreach str cmdfirstlst
            (write-line str f) ; first drawing's command
          )
          (if (not nosave) (write-line "_.qsave" f))
          (if (= nosave 2) (write-line
            "(if (/= (logand (getvar \"DBMOD\") 3) 0) (command \"_.QSAVE\"))" f)
          )

          ; Now do the rest of the drawings
          (setq slen (length dwglst))
          (setq ix 1)
          (while (< ix slen)
            ;(write-line "(if (/= (getvar \"DBMOD\") 0)(command \"_.OPEN\" \"_Y\")(command \"_.OPEN\"))" f)
            (if (wd_scr_is_sdi)
              (progn
                (write-line "(if (/= (getvar \"DBMOD\") 0)(command \"_.OPEN\" \"_Y\")(command \"_.OPEN\"))" f)
                (write-line (wd_1_longfname_delims (car dwglst)) f)
              )
            ; else
              (write-line (strcat "#ACE_PDSX_OPEN_SDI _Y " (wd_1_longfname_delims (car dwglst))) f)
            )
            (write-line (wd_1_longfname_delims (nth ix dwglst)) f)
            (write-line "_.zoom _e" f) ; in case zoomed way down

            (if (<= (wd_copy2wdm_acadver) 13) ; ** 26-Sep-98
              ; Force UNDO off
              (if (OR (not nosave) (= nosave "2")) (write-line ; *** 26-Aug-98 PMM
                "(if (= (logand (getvar \"UNDOCTL\") 1) 1)(command \"_.UNDO\" \"_C\" \"_N\"))" f))
            )
            (setq str (strcat "(princ \"  >> Drawing " (itoa (1+ ix)) " of "
                    (itoa dcnt) "\")(princ)"))
            (write-line str f)
            (foreach str cmdremainderlst
              (write-line str f)  ; command for 2nd thru nth dwgs
            )
            (if (not nosave) (write-line "_.qsave" f))
            (if (= nosave 2) (write-line
              "(if (/= (logand (getvar \"DBMOD\") 3) 0) (command \"_.QSAVE\"))" f)
            )

            (setq ix (1+ ix))
          )

          (if (<= (wd_copy2wdm_acadver) 13) ; ** 26-Sep-98
            ; Turn UNDO back on when all finished with drawing list
            (if (OR (not nosave) (= nosave 2)) (write-line ; *** 26-Aug-98 PMM
              "(if (= (getvar \"UNDOCTL\") 0)(command \"_.UNDO\" \"_A\"))" f))
          )
          (if (/= cmdpostlst nil)
            (progn ; do any final stuff after all drawings processed
              (foreach str cmdpostlst
                (write-line str f)
          ) ) )
          (close f)
          (setq f nil)
          (setq rtrn 1) ; success
        )
      )
  ) )
  (if Aw_debug (princ "\nOUT:wd_copy2wdm_build_script")) ; 14-Jun-98 NEHolt
  rtrn
)
; -----
(defun wd_copy2wdm_do_qsave ( / dcl_id accept)
  ; Perform QSAVE to cur dwg name but display dialog for confirmation Y/N
  ; Return 1=okay or no need to QSAVE, 0=no, nil=cancel
  (setq accept 1)
  (if (/= (logand (getvar "DBMOD") 3) 0)
    (progn ; something changed in object database or symbol table
;      (setq accept nil)
      (setq accept 0)  ; 17-Mar-98 NEHolt
      (if (= (getvar "DWGTITLED") 0) ; unnamed
        (progn
          (setq accept nil)
          (alert (c:wd_msg "GEN021" nil "This is an unnamed drawing. SAVE the drawing and then re-run the command."))
        )
      ; ELSE
        (progn ; Check if "Always QSAVE" flag set or a script file is
           ; active. For both cases to a QSAVE automatically
          (if (OR (= GBL_wd_qsok 1) (= (logand (getvar "CMDACTIVE") 4) 4)
                   GBL_wd_cmdlst)  ; ** 04-Oct-98 NEHolt OEM psuedo-script active
            (setq accept 1)
          ; ELSE
            (progn
; ** 16-Apr-04; LeeH            
;;;              (setq dcl_id (load_dialog (strcat GBL_wd_sup "wdcom9.dcl")))
              (setq dcl_id (load_dialog (strcat GBL_wd_sup "wdvis.dcl")))
; **              
              (if (not (new_dialog "do_qsave_dlg" dcl_id)) (exit))
              (setq accept nil)
              (action_tile "accept" "(setq accept 1)(done_dialog)")
              (action_tile "b_no" "(setq accept 0)(done_dialog)")
              (action_tile "b_always"
                 "(setq accept 1)(setq GBL_wd_qsok 1)(done_dialog)")
              (action_tile "cancel" "(setq accept nil)(done_dialog)") ; 17-Mar-98
              (start_dialog)
              (unload_dialog dcl_id)
          ) )
          (if (= accept 1) (command "_.QSAVE"))
  ) ) ) )
  accept
)
; ----
(defun wd_copy2wdm_acadver ( / x xx)
  (setq x 14) ; OEM default to R14
  ; Note AutoCAD OEM does not support ACADVER, so return 14 for OEM
  (if (setq xx (getvar "ACADVER")) (setq x (atoi xx)))
  x ; return INT 13 or 14
)
; -----
(defun wd_1_longfname_delims ( str / hit rtrn slen ix )
  ; Look for embedded spaces in file name. Put double quotes around
  (setq rtrn str)
  (setq hit nil)
  (if str
    (progn
      (setq str (wd_1_rmv_leading_blnks str))
      (setq slen (strlen str))
      (setq ix 1)
      (while (AND (not hit) (< ix slen))
        (if (= (substr str ix 1) " ") (setq hit 1)) ; found space
        (setq ix (1+ ix))
      )
      (if (AND hit (/= (substr str 1 1) "\""))  ; ** 05-Feb-98 NEHolt
         (setq rtrn (strcat "\"" str "\""))) ; add double quote delims
  ) )
  rtrn
)
; -------
(defun wd_1_rmv_leading_blnks ( str / )
  (if str
    (progn
      (while (AND (> (strlen str) 0) (= (substr str 1 1) " "))
        (setq str (substr str 2))
  ) ) )
  str ; return char string with leading spaces removed
)
; ---
(defun wd_copy2wdm_is_txtfixedhgt ( / ed x)
  ; Check if current text style has a pre-defined text height
  (setq x nil)
  (setq ed (tblsearch "style" (getvar "TEXTSTYLE")))
  (if ed
    (progn
      (setq x (cdr (assoc 40 ed)))
      (if (/= x 0.0) (setq x 1) (setq x nil))
    )
  )
  x ; return 1 if current text style has fixed hgt, nil otherwise
)
; ----
(defun wd_copy2wdm_ins_attdef (atnam prompt defval xy hgt / en ed)

; ** 20-May-99 NEHolt
  ; Set attributes to INVISIBLE mode
  (setvar "AFLAGS" 1)
; **
  (if (wd_copy2wdm_is_txtfixedhgt)
    (command "_.ATTDEF" "" atnam prompt defval xy "0")
  ; ELSE
    (command "_.ATTDEF" "" atnam prompt defval xy hgt "0")
  )
  (setq en (entlast))
  (setq ed (entget en))
  (setq ed (subst (cons 40 0.01) (assoc 40 ed) ed)) ; make sure hgt is correct
  (setq ed (subst (cons 8 "0") (assoc 8 ed) ed)) ; layer 0
  (if (assoc 62 ed)
    (setq ed (subst (cons 62 256) (assoc 62 ed) ed)) ; color BYLAYER
  )
  (entmod ed)
  (princ (strcat "\n" (c:wd_msg "CP2WDM010" (list atnam) "Inserted \"%1\" Attribute Definition")))
)
; -----
(defun wd_copy2wdm_rename_lay ( old_lay new_lay / )
  ; rename old_lay new_lay if old exists and new doesn't
  (if (AND (tblsearch "LAYER" old_lay)
           new_lay (/= new_lay "") ; ** 20-May-99 NEHolt
           (not (tblsearch "LAYER" new_lay)))
    (progn
      ; exists so rename it
      (princ (strcat "\n" (c:wd_msg "EDLAY006" (list old_lay new_lay) "Renamed %1 --> %2")))
      (command "_.RENAME" "_LAYER" old_lay new_lay) ; ** 22-Jun-04 NEHolt globalized
    )
  )
)
(princ)
